package Composite;

import java.util.ArrayList;
import java.util.List;

class Folder implements FileSystemComponent {
    private String name;
    private List<FileSystemComponent> components = new ArrayList<>();

    public Folder(String name) {
        this.name = name;
    }

    public void addComponent(FileSystemComponent component) {
        components.add(component);
    }

    @Override
    public int getSize() {
        int totalSize = 0;
        for (FileSystemComponent component : components) {
            totalSize += component.getSize();
        }
        return totalSize;
    }

    @Override
    public int getNumberOfFiles() {
        int count = 0;
        for (FileSystemComponent component : components) {
            count += component.getNumberOfFiles();
        }
        return count;
    }

    @Override
    public int getNumberOfFolders() {
        int count = 1; // Counting itself as a folder
        for (FileSystemComponent component : components) {
            count += component.getNumberOfFolders();
        }
        return count;
    }

    @Override
    public boolean search(String target) {
        if (name.equals(target)) {
            return true;
        }
        for (FileSystemComponent component : components) {
            if (component.search(target)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void printDetails() {
        System.out.println("Folder: " + name);
        System.out.println("Contents:");
        for (FileSystemComponent component : components) {
            component.printDetails();
        }
    }
}
